
local Assets =
{
	Asset("ANIM", "anim/firehelm.zip"),
 Asset("IMAGE", "images/inventoryimages/firehelm.tex"),
 Asset("ATLAS", "images/inventoryimages/firehelm.xml"),  
}

local function turnon(inst)
inst:AddTag("turnon")
        inst.Light:Enable(true)
		if inst.components.fueled then
			inst.components.fueled:StartConsuming()        
		end
end

local function turnoff(inst)
inst:RemoveTag("turnon")
        inst.Light:Enable(false)
	        if inst.components.fueled then
		inst.components.fueled:StopConsuming()        
	        end
end

local function firethree(inst, owner)
         if owner:HasTag("fire1") and owner:HasTag("fire2") and owner:HasTag("fire3") then
         owner.components.health.fire_damage_scale = 0
	          inst.components.dapperness.dapperness = TUNING.DAPPERNESS_LARGE
                  inst.Light:SetRadius(20)

         else        
                     if GetPlayer() and GetPlayer().prefab ~= "willow" then
                       owner.components.health.fire_damage_scale = 0.5
	          inst.components.dapperness.dapperness = TUNING.DAPPERNESS_SMALL
                     end
                  inst.Light:SetRadius(4)
           end
end

local function onequip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_hat", "firehelm", "swap_hat")
        owner.AnimState:Show("HAT")
        owner.AnimState:Show("HAT_HAIR")
        owner.AnimState:Hide("HAIR_NOHAT")
        owner.AnimState:Hide("HAIR")
        owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")     
        if owner:HasTag("player") then
			owner.AnimState:Hide("HEAD")
			owner.AnimState:Show("HEAD_HAIR")
           owner:AddTag("fire3")
                    inst.task = inst:DoPeriodicTask(0.5, function() firethree(inst, owner) end)

	end
	if GetClock():IsDay() then
    turnoff(inst)
        else
    turnon(inst)
        end
    inst:ListenForEvent( "daytime", function() turnoff(inst) end , GetWorld())
    inst:ListenForEvent( "nighttime", function() turnon(inst) end , GetWorld())

end 

local function onunequip(inst, owner)
        owner.AnimState:Hide("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")

		if owner:HasTag("player") then
	        owner.AnimState:Show("HEAD")
			owner.AnimState:Hide("HEAD_HAIR")
                owner:RemoveTag("fire3")
                     if GetPlayer() and GetPlayer().prefab ~= "willow" then
                     owner.components.health.fire_damage_scale = 1
                     end
		end

if inst.task then inst.task:Cancel() inst.task = nil end
    turnoff(inst)
inst.components.useableitem:StopUsingItem()
end

local function onuse(inst)
if inst:HasTag("turnon") then
    turnoff(inst)
else
    turnon(inst)
end
end

local function fuelupdate(inst)
        if GetSeasonManager() and GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 1 + TUNING.FIREPIT_RAIN_RATE*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 1
        end
end

local function nofuel(inst)
if inst.task then inst.task:Cancel() inst.task = nil end
    local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
    if owner then
        owner:PushEvent("torchranout", {torch = inst})
    end
    inst:Remove()
        if owner and owner.components.inventory then
            local redgem = SpawnPrefab("redgem")
            owner.components.inventory:GiveItem(redgem)
        end
end

local function ondropped(inst)
    turnoff(inst)
end

local function onputininventory(inst)
    turnoff(inst)
end

local function fn(Sim)
        local inst = CreateEntity()

        inst.entity:AddTransform()
        inst.entity:AddAnimState()
        MakeInventoryPhysics(inst)

        inst.AnimState:SetBank("footballhat")
        inst.AnimState:SetBuild("firehelm")
        inst.AnimState:PlayAnimation("anim")

        inst:AddTag("firehelm")

        inst:AddComponent("inspectable")

        inst:AddComponent("inventoryitem")

    inst.components.inventoryitem.atlasname = "images/inventoryimages/firehelm.xml"
 
        local light = inst.entity:AddLight()
        light:SetFalloff(0.5)
        light:SetIntensity(.8)
        light:SetRadius(4)
        light:SetColour(231/255, 29/255, 18/255)
        light:Enable(false)

    inst.components.inventoryitem:SetOnDroppedFn(ondropped)
    inst.components.inventoryitem:SetOnPutInInventoryFn(onputininventory)

        inst:AddComponent("equippable")
        inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
        inst.components.equippable:SetOnEquip( onequip )
        inst.components.equippable:SetOnUnequip( onunequip )

	inst:AddComponent("dapperness")

        inst:AddComponent("fueled")
        inst.components.fueled.fueltype = "GEMFUEL"
        inst.components.fueled:InitializeFuelLevel(480 * 4)
    inst.components.fueled:SetUpdateFn(fuelupdate)
    inst.components.fueled:SetDepletedFn(nofuel)
    inst.components.fueled.accepting = true

    inst:AddComponent("useableitem")
    inst.components.useableitem:SetOnUseFn(onuse)

        return inst
end

return Prefab( "common/inventory/firehelm", fn, Assets)

